local cursor, cursor_move_sfx, choice_made_sfx
local names = {
	THEME:GetString("Intro", "12-Choice1"),
	THEME:GetString("Intro", "12-Choice2"),
}

local dialog = {
	{ text=THEME:GetString("Intro", "1") },
	{ text=THEME:GetString("Intro", "2") },
	{ text=THEME:GetString("Intro", "3") },
	{ text=THEME:GetString("Intro", "4") },
	{ text=THEME:GetString("Intro", "5") },
	{ text=THEME:GetString("Intro", "6") },
	{ text=THEME:GetString("Intro", "7") },
	{ text=THEME:GetString("Intro", "8") },
	-- {
	-- 	text=THEME:GetString("Intro", "9"),
	-- 	choices={
	-- 		THEME:GetString("Intro", "9-Choice1"),
	-- 		THEME:GetString("Intro", "9-Choice2"),
	-- 	}
	-- },
	{
		text=THEME:GetString("Intro", "10"),
		choices={
			THEME:GetString("Intro", "10-Choice1"),
			THEME:GetString("Intro", "10-Choice2"),
		}
	},
	{
		text=function()

			GAMESTATE:UnjoinPlayer(PLAYER_2)
			GAMESTATE:SetCurrentPlayMode("PlayMode_Regular")
			GAMESTATE:SetCurrentStyle("single")

			if SRT.Dialog.ChoiceIndex == 1 then
				return THEME:GetString("Intro", "11-1")
			elseif SRT.Dialog.ChoiceIndex == 2 then
				return THEME:GetString("Intro", "11-2")
			end
		end,
	},
	{
		text=THEME:GetString("Intro", "12"),
		choices=names
	},
	{
		text=function()
			SRT.Player.Name = names[SRT.Dialog.ChoiceIndex]
			return SRT.Player.Name  .. "!  " .. THEME:GetString("Intro", "13")
		end
	},
	{ text=THEME:GetString("Intro", "14") },
}

SRT.Dialog.Words = dialog
----------------------------------------------------------------------------

local InputHandler = function(event)

	-- if any of these, don't attempt to handle input
	if not event.PlayerNumber or not event.button then
		return false
	end

	if event.type == "InputEventType_FirstPress" then

		if event.GameButton == "Start" then

			local topscreen = SCREENMAN:GetTopScreen()
			local overlay = topscreen:GetChild("Overlay")

			if not SRT.Dialog.IsTweening then
				-- update the dialog index
				SRT.Dialog.Index = SRT.Dialog.Index + 1

				-- then, clear the old text
				overlay:queuecommand("ClearText")

				-- then, ensure that there is more load
				if SRT.Dialog.Index <= #dialog then
					-- if so, display it
					overlay:queuecommand("UpdateText")
					if SRT.Dialog.Words[SRT.Dialog.Index-1].choices then
						choice_made_sfx:play()
					end
				else

					SRT.Dialog.Index = 1
					-- otherwise, transition the screen

					topscreen:SetNextScreenName("Overworld")
					overlay:queuecommand("TransitionScreen")
				end
			else
				SRT.Dialog.Box:GetChild("Text"):finishtweening()
				SRT.Dialog.IsTweening = false
			end
		elseif event.GameButton == "MenuRight" then
			if SRT.Dialog.Words[SRT.Dialog.Index].choices then
				SRT.Dialog.ChoiceIndex = ((SRT.Dialog.ChoiceIndex+1) % #SRT.Dialog.Words[SRT.Dialog.Index].choices)
				if SRT.Dialog.ChoiceIndex == 0 then SRT.Dialog.ChoiceIndex = #SRT.Dialog.Words[SRT.Dialog.Index].choices end
				SRT.Dialog.Cursor:queuecommand("UpdateCursor")
				cursor_move_sfx:play()
			end
		elseif event.GameButton == "MenuLeft" then
			if SRT.Dialog.Words[SRT.Dialog.Index].choices then
				SRT.Dialog.ChoiceIndex = ((SRT.Dialog.ChoiceIndex-1) % #SRT.Dialog.Words[SRT.Dialog.Index].choices)
				if SRT.Dialog.ChoiceIndex == 0 then SRT.Dialog.ChoiceIndex = #SRT.Dialog.Words[SRT.Dialog.Index].choices end
				SRT.Dialog.Cursor:queuecommand("UpdateCursor")
				cursor_move_sfx:play()
			end
		end
	end

	return false
end

----------------------------------------------------------------------------




local af = Def.ActorFrame{
	InitCommand=function(self)
		-- change the DialogBox'x border to be purple
		SRT.Dialog.Box:playcommand("UpdateColor", {Color=color("#7452b5")})
		-- queue until one frame later so we can get the correct TopScreen
		self:queuecommand("Capture")
	end,
	CaptureCommand=function(self)
		SCREENMAN:GetTopScreen():AddInputCallback( InputHandler )
	end,
	OnCommand=function(self)
		SRT.Dialog.Box:sleep(1.5):queuecommand("Show")
		self:sleep(3):queuecommand("ClearText"):queuecommand("UpdateText")
	end
}

local t = Def.ActorFrame{
	InitCommand=function(self) self:fov(90) end,

	-- color the backgroud white
	Def.Quad{
		InitCommand=function(self)
			self:FullScreen():diffuse(0.25,0.25,0.25,0.9)
		end
	},

	LoadActor("./grid.png")..{
		OnCommand=function(self)
			self:FullScreen():rotationx(-82):zoom(1.1)
				:customtexturerect(0,0,4,4):texcoordvelocity(0,0.05)
		end
	}
}

af[#af+1] = t

-- fade the top of the grid by covering it
af[#af+1] = Def.Quad{
	InitCommand=function(self)
		self:FullScreen():Center():fadebottom(0.5)
	end,
	TransitionScreenCommand=function(self)
		SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
	end,
}

-- darken the entire screen partially
af[#af+1] = Def.Quad{
	InitCommand=function(self)
		self:FullScreen():Center():diffuse(0.1,0.15,0.15,0.45)
	end,
	OffCommand=function(self)
		self:linear(1):diffuse(0,0,0,1)
	end,
}

-- Professor Taro
af[#af+1] = LoadActor("./TaroAndSami.png")..{
	InitCommand=function(self)
		local zoom_factor = 0.1675
		local ar = string.format( "%.3f" ,PREFSMAN:GetPreference("DisplayAspectRatio"))
		if ar == "1.333" then zoom_factor = 0.25 end

		self:zoom(zoom_factor):xy(_screen.cx, _screen.cy-30):diffusealpha(0)
	end,
	OnCommand=function(self)
		self:sleep(2):linear(0.5):diffusealpha(1)
	end,
	UpdateTextCommand=function(self)
		if SRT.Dialog.Index == #dialog-2 then
			self:linear(0.8):diffusealpha(0):queuecommand("ChangeToReen")
		end
	end,
	ChangeToReenCommand=function(self)
		self:Load( THEME:GetPathB("Intro", "overlay/Reen.png") )
			:linear(0.8):diffusealpha(1)
	end
}

-- dialog box
af[#af+1] = LoadActor(THEME:GetPathB("","_DialogBox.lua"))


---------------------------------------------------------------------------------------------
-- fade in/out
af[#af+1] = Def.Quad{
	InitCommand=function(self)
		self:FullScreen():Center():diffuse(0,0,0,1)
	end,
	OnCommand=function(self)
		self:linear(1):diffusealpha(0)
	end,
	OffCommand=function(self)
		self:diffuse(1,1,1,0):linear(0.8):diffusealpha(1):decelerate(0.2):diffuse(0,0,0,1)
	end
}

---------------------------------------------------------------------------------------------
t[#t+1] = Def.Sound{
	File=THEME:GetPathS("Common", "value.ogg"),
	InitCommand=function(self) cursor_move_sfx = self end
}

t[#t+1] = Def.Sound{
	File=THEME:GetPathS("Common", "start.ogg"),
	InitCommand=function(self) choice_made_sfx = self end
}


return af